/*
 * Decompiled with CFR 0.152.
 */
package com.yollo.dmlreforged.core.configs;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;

public class MobConfig {
    private static HashMap<String, ForgeConfigSpec.ConfigValue<List<? extends String>>> PRISTINELOOT = new HashMap();
    private static HashMap<String, ForgeConfigSpec.ConfigValue<List<? extends String>>> ACCEPTEDMOBS = new HashMap();

    public static void registerCommonConfig(ForgeConfigSpec.Builder COMMON_BUILDER) {
        COMMON_BUILDER.comment(new String[]{"Add custom mob to count for data learning.", "IMPORTANT NOTICE:", "THIS IS ONLY THE COMMON CONFIG. It does not contain all the values adjustable for DMLReforged.", "All modifiers for machines, and most other adjustable values have been moved to dmlreforged-server.toml.", "That file is PER WORLD, meaning you have to go into 'saves/<world name>/serverconfig' to adjust it. Those changes will then only apply for THAT WORLD.", "You can then take that config file and put it in the 'defaultconfigs' folder to make it apply automatically to all NEW worlds you generate FROM THERE ON.", "This may appear confusing to many of you, but it is a new sensible way to handle configuration, because the server configuration is synced when playing multiplayer.", "- Credit for this notification: BluSunrize (ImmersiveEngineering)"}).push("mob_registry");
        COMMON_BUILDER.push("mobs");
        ACCEPTEDMOBS.put("blaze", (ForgeConfigSpec.ConfigValue<List<? extends String>>)COMMON_BUILDER.defineList("blaze", Arrays.asList(MOBS.BLAZE), o -> o instanceof String));
        ACCEPTEDMOBS.put("creeper", (ForgeConfigSpec.ConfigValue<List<? extends String>>)COMMON_BUILDER.defineList("creeper", Arrays.asList(MOBS.CREEPER), o -> o instanceof String));
        ACCEPTEDMOBS.put("dragon", (ForgeConfigSpec.ConfigValue<List<? extends String>>)COMMON_BUILDER.defineList("dragon", Arrays.asList(MOBS.DRAGON), o -> o instanceof String));
        ACCEPTEDMOBS.put("enderman", (ForgeConfigSpec.ConfigValue<List<? extends String>>)COMMON_BUILDER.defineList("enderman", Arrays.asList(MOBS.ENDERMAN), o -> o instanceof String));
        ACCEPTEDMOBS.put("ghast", (ForgeConfigSpec.ConfigValue<List<? extends String>>)COMMON_BUILDER.defineList("ghast", Arrays.asList(MOBS.GHAST), o -> o instanceof String));
        ACCEPTEDMOBS.put("skeleton", (ForgeConfigSpec.ConfigValue<List<? extends String>>)COMMON_BUILDER.defineList("skeleton", Arrays.asList(MOBS.SKELETON), o -> o instanceof String));
        ACCEPTEDMOBS.put("slime", (ForgeConfigSpec.ConfigValue<List<? extends String>>)COMMON_BUILDER.defineList("slime", Arrays.asList(MOBS.SLIME), o -> o instanceof String));
        ACCEPTEDMOBS.put("spider", (ForgeConfigSpec.ConfigValue<List<? extends String>>)COMMON_BUILDER.defineList("spider", Arrays.asList(MOBS.SPIDER), o -> o instanceof String));
        ACCEPTEDMOBS.put("witch", (ForgeConfigSpec.ConfigValue<List<? extends String>>)COMMON_BUILDER.defineList("witch", Arrays.asList(MOBS.WITCH), o -> o instanceof String));
        ACCEPTEDMOBS.put("wither", (ForgeConfigSpec.ConfigValue<List<? extends String>>)COMMON_BUILDER.defineList("wither", Arrays.asList(MOBS.WITHER), o -> o instanceof String));
        ACCEPTEDMOBS.put("zombie", (ForgeConfigSpec.ConfigValue<List<? extends String>>)COMMON_BUILDER.defineList("zombie", Arrays.asList(MOBS.ZOMBIE), o -> o instanceof String));
        ACCEPTEDMOBS.put("shulker", (ForgeConfigSpec.ConfigValue<List<? extends String>>)COMMON_BUILDER.defineList("shulker", Arrays.asList(MOBS.SHULKER), o -> o instanceof String));
        ACCEPTEDMOBS.put("guardian", (ForgeConfigSpec.ConfigValue<List<? extends String>>)COMMON_BUILDER.defineList("guardian", Arrays.asList(MOBS.GUARDIAN), o -> o instanceof String));
        ACCEPTEDMOBS.put("witherskeleton", (ForgeConfigSpec.ConfigValue<List<? extends String>>)COMMON_BUILDER.defineList("witherskeleton", Arrays.asList(MOBS.WITHERSKELETON), o -> o instanceof String));
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Add generated loot from fabricating pristine matter").push("loot_assign");
        PRISTINELOOT.put("blaze", (ForgeConfigSpec.ConfigValue<List<? extends String>>)COMMON_BUILDER.defineList("blaze", Arrays.asList(LOOT.BLAZE), o -> o instanceof String));
        PRISTINELOOT.put("creeper", (ForgeConfigSpec.ConfigValue<List<? extends String>>)COMMON_BUILDER.defineList("creeper", Arrays.asList(LOOT.CREEPER), o -> o instanceof String));
        PRISTINELOOT.put("dragon", (ForgeConfigSpec.ConfigValue<List<? extends String>>)COMMON_BUILDER.defineList("dragon", Arrays.asList(LOOT.DRAGON), o -> o instanceof String));
        PRISTINELOOT.put("enderman", (ForgeConfigSpec.ConfigValue<List<? extends String>>)COMMON_BUILDER.defineList("enderman", Arrays.asList(LOOT.ENDERMAN), o -> o instanceof String));
        PRISTINELOOT.put("ghast", (ForgeConfigSpec.ConfigValue<List<? extends String>>)COMMON_BUILDER.defineList("ghast", Arrays.asList(LOOT.GHAST), o -> o instanceof String));
        PRISTINELOOT.put("skeleton", (ForgeConfigSpec.ConfigValue<List<? extends String>>)COMMON_BUILDER.defineList("skeleton", Arrays.asList(LOOT.SKELETON), o -> o instanceof String));
        PRISTINELOOT.put("slime", (ForgeConfigSpec.ConfigValue<List<? extends String>>)COMMON_BUILDER.defineList("slime", Arrays.asList(LOOT.SLIME), o -> o instanceof String));
        PRISTINELOOT.put("spider", (ForgeConfigSpec.ConfigValue<List<? extends String>>)COMMON_BUILDER.defineList("spider", Arrays.asList(LOOT.SPIDER), o -> o instanceof String));
        PRISTINELOOT.put("witch", (ForgeConfigSpec.ConfigValue<List<? extends String>>)COMMON_BUILDER.defineList("witch", Arrays.asList(LOOT.WITCH), o -> o instanceof String));
        PRISTINELOOT.put("wither", (ForgeConfigSpec.ConfigValue<List<? extends String>>)COMMON_BUILDER.defineList("wither", Arrays.asList(LOOT.WITHER), o -> o instanceof String));
        PRISTINELOOT.put("zombie", (ForgeConfigSpec.ConfigValue<List<? extends String>>)COMMON_BUILDER.defineList("zombie", Arrays.asList(LOOT.ZOMBIE), o -> o instanceof String));
        PRISTINELOOT.put("shulker", (ForgeConfigSpec.ConfigValue<List<? extends String>>)COMMON_BUILDER.defineList("shulker", Arrays.asList(LOOT.SHULKER), o -> o instanceof String));
        PRISTINELOOT.put("guardian", (ForgeConfigSpec.ConfigValue<List<? extends String>>)COMMON_BUILDER.defineList("guardian", Arrays.asList(LOOT.GUARDIAN), o -> o instanceof String));
        PRISTINELOOT.put("witherskeleton", (ForgeConfigSpec.ConfigValue<List<? extends String>>)COMMON_BUILDER.defineList("witherskeleton", Arrays.asList(LOOT.WITHERSKELETON), o -> o instanceof String));
        COMMON_BUILDER.pop(2);
    }

    public static final List<? extends String> getMobs(String name) {
        return (List)ACCEPTEDMOBS.get(name).get();
    }

    public static List<? extends String> getPristineLoot(String key) {
        return (List)PRISTINELOOT.get(key).get();
    }

    public static ItemStack getStackFromConfigLine(String line) {
        int amount;
        String[] vals = line.split(",");
        if (vals.length < 2) {
            return ItemStack.f_41583_;
        }
        ResourceLocation itemLocation = new ResourceLocation(vals[0]);
        try {
            amount = Integer.parseInt(vals[1]);
        }
        catch (NumberFormatException e) {
            System.out.println("Not a valid number for amount");
            return ItemStack.f_41583_;
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(itemLocation);
        if (item != null) {
            return new ItemStack((ItemLike)item, amount);
        }
        return ItemStack.f_41583_;
    }

    public static NonNullList<ItemStack> getLootTable(String key) {
        NonNullList list = NonNullList.m_122779_();
        List<? extends String> toParseList = MobConfig.getPristineLoot(key);
        for (String string : toParseList) {
            if (MobConfig.getStackFromConfigLine(string).m_41619_()) continue;
            list.add((Object)MobConfig.getStackFromConfigLine(string));
        }
        return list;
    }

    public static final class MOBS {
        public static final String[] CREEPER = new String[]{"minecraft:creeper"};
        public static final String[] BLAZE = new String[]{"minecraft:blaze"};
        public static final String[] DRAGON = new String[]{"minecraft:ender_dragon"};
        public static final String[] ENDERMAN = new String[]{"minecraft:enderman", "deepmoblearning:trial_enderman"};
        public static final String[] GHAST = new String[]{"minecraft:ghast"};
        public static final String[] SKELETON = new String[]{"minecraft:stray", "minecraft:skeleton", "twilightforest:skeleton_druid"};
        public static final String[] SLIME = new String[]{"minecraft:slime", "minecraft:magma_cube", "deepmoblearning:trial_slime"};
        public static final String[] SPIDER = new String[]{"minecraft:spider", "minecraft:cave_spider", "twilightforest:hedge_spider", "twilightforest:king_spider", "deepmoblearning:trial_spider", "deepmoblearning:trial_cave_spider"};
        public static final String[] WITCH = new String[]{"minecraft:witch"};
        public static final String[] WITHERSKELETON = new String[]{"minecraft:wither_skeleton"};
        public static final String[] WITHER = new String[]{"minecraft:wither"};
        public static final String[] ZOMBIE = new String[]{"minecraft:husk", "minecraft:zombie", "minecraft:zombie_villager", "minecraft:zombie_pigman"};
        public static final String[] SHULKER = new String[]{"minecraft:shulker"};
        public static final String[] GUARDIAN = new String[]{"minecraft:elder_guardian", "minecraft:guardian"};
    }

    public static final class LOOT {
        public static final String[] CREEPER = new String[]{"minecraft:gunpowder,64", "minecraft:skull,6"};
        public static final String[] BLAZE = new String[]{"minecraft:blaze_rod,22", "thermalfoundation:material,32"};
        public static final String[] DRAGON = new String[]{"minecraft:dragon_breath,32", "minecraft:dragon_egg,1", "draconicevolution:dragon_heart,1", "draconicevolution:draconium_dust,64"};
        public static final String[] ENDERMAN = new String[]{"minecraft:ender_pearl,6", "minecraft:end_crystal,1", "enderio:block_enderman_skull,2"};
        public static final String[] GHAST = new String[]{"minecraft:ghast_tear,8"};
        public static final String[] SKELETON = new String[]{"minecraft:bone,64", "minecraft:arrow,64", "minecraft:skull,6"};
        public static final String[] SLIME = new String[]{"minecraft:slime_ball,32"};
        public static final String[] SPIDER = new String[]{"minecraft:spider_eye,16", "minecraft:string,64", "minecraft:web,8"};
        public static final String[] WITCH = new String[]{"minecraft:redstone,32", "minecraft:glowstone_dust,32", "minecraft:sugar,64"};
        public static final String[] WITHERSKELETON = new String[]{"minecraft:skull,18", "minecraft:coal,64"};
        public static final String[] WITHER = new String[]{"minecraft:nether_star,3"};
        public static final String[] ZOMBIE = new String[]{"minecraft:rotten_flesh,64", "minecraft:iron_ingot,16", "minecraft:carrot,32", "minecraft:potato,32"};
        public static final String[] SHULKER = new String[]{"minecraft:shulker_shell,18", "minecraft:diamond,2"};
        public static final String[] GUARDIAN = new String[]{"minecraft:prismarine_shard,32", "minecraft:prismarine_crystals,32", "minecraft:fish,64"};
    }
}

